/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import net.fabricmc.loader.api.FabricLoader;

public class ChallengeSettings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("challenges6t4.json").toFile();
    private static Map<String, Boolean> enabledChallenges = new HashMap<String, Boolean>();
    private static Map<String, Map<String, Object>> challengeOptions = new HashMap<String, Map<String, Object>>();

    public static void loadSettings() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    if (loaded.containsKey("enabled")) {
                        enabledChallenges = (Map)loaded.get("enabled");
                        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                            Boolean enabled = enabledChallenges.get(challenge.getId());
                            if (enabled == null) continue;
                            challenge.setEnabled(enabled);
                        }
                    }
                    if (loaded.containsKey("options")) {
                        challengeOptions = (Map)loaded.get("options");
                    }
                }
            }
            catch (IOException | ClassCastException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveSettings() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                enabledChallenges.clear();
                for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                    enabledChallenges.put(challenge.getId(), challenge.isEnabled());
                }
                HashMap<String, Map<String, Object>> settings = new HashMap<String, Map<String, Object>>();
                settings.put("enabled", enabledChallenges);
                settings.put("options", challengeOptions);
                GSON.toJson(settings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isEnabled(String challengeId) {
        return enabledChallenges.getOrDefault(challengeId, false);
    }

    public static void setEnabled(String challengeId, boolean enabled) {
        enabledChallenges.put(challengeId, enabled);
        ChallengeSettings.saveSettings();
    }

    public static boolean hasOption(String challengeId, String optionKey) {
        Map<String, Object> options = challengeOptions.get(challengeId);
        return options != null && options.containsKey(optionKey);
    }

    public static int getIntOption(String challengeId, String optionKey, int defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public static void setIntOption(String challengeId, String optionKey, int value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, value);
        ChallengeSettings.saveSettings();
    }

    public static boolean getBooleanOption(String challengeId, String optionKey, boolean defaultValue) {
        Object value;
        Map<String, Object> options = challengeOptions.get(challengeId);
        if (options != null && options.containsKey(optionKey) && (value = options.get(optionKey)) instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static void setBooleanOption(String challengeId, String optionKey, boolean value) {
        Map options = challengeOptions.computeIfAbsent(challengeId, k -> new HashMap());
        options.put(optionKey, value);
        ChallengeSettings.saveSettings();
    }
}

